#!/bin/bash

filetime="$(date +%m%d%H%M%S)"
SUDO=`which sudo`
INSTALL=`which install`
ROOT_INSTALL=$INSTALL' -o root -g root'
ARCH=`uname -m`

if [ $ARCH == "x86_64" ]; then
SRC="x86_64"
LIB="lib64"
else
SRC="i686"
LIB="lib"
fi

echo "========================================"
echo "        PenMount X Installation         "
echo "========================================"

echo "[Installer] Stopping PenMount Utilities ..."
$SUDO killall -q gDraw gCal gPen

echo "[Installer] Copying PenMount Utilities ..."
$SUDO $ROOT_INSTALL $SRC/pm-setup             /usr/sbin
$SUDO $ROOT_INSTALL $SRC/gCal                 /usr/sbin
$SUDO $ROOT_INSTALL $SRC/gDraw                /usr/sbin
$SUDO $ROOT_INSTALL $SRC/gPen                 /usr/sbin
$SUDO $ROOT_INSTALL -m 4755 $SRC/gPen-wrapper /usr/sbin
$SUDO $ROOT_INSTALL -m 4755 $SRC/gCal-wrapper /usr/sbin

echo "[Installer] Copying PenMount Resource Files..."
$SUDO mkdir -p /usr/share/penmount
$SUDO $ROOT_INSTALL penmount.png     /usr/share/penmount
$SUDO $ROOT_INSTALL README /usr/share/penmount

$SUDO $ROOT_INSTALL penmount.dat     /etc
$SUDO $ROOT_INSTALL penmount48.png   /usr/share/pixmaps/penmount.png
$SUDO $ROOT_INSTALL penmount48.png   /usr/share/icons/gnome/48x48/apps/penmount.png
$SUDO $ROOT_INSTALL penmount32.png   /usr/share/icons/gnome/32x32/apps/penmount.png
$SUDO $ROOT_INSTALL penmount24.png   /usr/share/icons/gnome/24x24/apps/penmount.png
$SUDO $ROOT_INSTALL penmount22.png   /usr/share/icons/gnome/22x22/apps/penmount.png
$SUDO $ROOT_INSTALL penmount16.png   /usr/share/icons/gnome/16x16/apps/penmount.png
$SUDO $ROOT_INSTALL penmount.desktop /usr/share/applications

if [ -f /usr/share/gnome-menus/update-gnome-menus-cache ]
then
/usr/share/gnome-menus/update-gnome-menus-cache /usr/share/applications > ~/desktop.en_US.utf8.cache
$SUDO mv ~/desktop.en_US.utf8.cache /usr/share/applications/desktop.en_US.utf8.cache
fi

if [ ! -d ~/.config/autostart ]
then
mkdir -p ~/.config/autostart
fi
$INSTALL penmount_autostart.desktop ~/.config/autostart/penmount.desktop

echo "[Installer] Setting up X Server ..."
$SUDO /usr/sbin/pm-setup -s
$SUDO udevadm trigger --action=add --subsystem-match=input

echo "[Installer] Copying PenMount XInput Module file"
$SUDO find /usr/lib/xorg/modules/ -name penmount_drv.so -type f -delete
$SUDO $ROOT_INSTALL $SRC/penmount_drv.so /usr/$LIB/xorg/modules/input

echo "========================================"
echo "    PenMount Installation Finished !    "
echo "========================================"
echo "[Installer] Please restart X to make changes take effect !"
